\name{ExtractBy}
\alias{ExtractBy}
\title{
Extract and organize \code{DNAStringSets}s.
}
\description{
Return organized \code{DNAStringSet}s based on three currently supported object combinations. First return a single \code{DNAStringSet} of feature sequences from a DFrame of genecalls and a \code{DNAStingSet} of the source assembly. Second return a list of \code{DNAStringSet}s of predicted pairs from a \code{PairSummaries} object and a character string of the location of a \code{DECIPHER} SQLite database. Third return a list of \code{DNAStringSet}s of predicted single linkage communities from a \code{PairSummaries} object, a character string of the location of a \code{DECIPHER} SQLite database, and a list of identifiers generated by \code{DisjointSet}.
}
\usage{
ExtractBy(x,
          y,
          z,
          Verbose = FALSE)
}
\arguments{
  \item{x}{
A \code{PairSummaries} object, or if \code{y} is a \code{DNAStringSet}, a \code{DFrame} of gene calls such as one generated by \code{gffToDataFrame}.
}
  \item{y}{
A character vector of length 1 indicating the location of a \code{DECIPHER} SQLite database. Or, if \code{x} is a \code{DFrame}, a \code{DNAStringSet} of the assembly the gene calls are called from.
}
  \item{z}{
Optional; a list of identifiers generated by \code{DisjointSet}. Or any list built along a similar format with identifiers paired to the PairSummaries object.
}
  \item{Verbose}{
Logical indicating whether to print progress bars and messages. Defaults to \code{FALSE}.
}
}
\details{
All sequences are forced into the same direction based on the \code{Strand} column supplied by either the gene calls \code{DFrame} specified by \code{x}, or the \code{GeneCalls} attribute of the \code{PairSummaries} object specified by \code{y}.
}
\value{
Return a \code{DNAStringSet}, or list of \code{DNAStringSet}s arranged depending upon the objects supplied. See description.
}
\author{
Nicholas Cooley \email{npc19@pitt.edu}
}

\seealso{
\code{\link{FindSynteny}}, \code{\link{Synteny-class}}, \code{\link{PairSummaries}}, \code{\link{DisjointSet}}
}
\examples{
DBPATH <- system.file("extdata",
                      "Endosymbionts_v05a.sqlite",
                      package = "SynExtend")
data("Endosymbionts_Pairs03", package = "SynExtend")
data("Endosymbionts_Sets", package = "SynExtend")

# extract the first 10 disjoint sets
Sets <- ExtractBy(x = Endosymbionts_Pairs03,
                  y = DBPATH,
                  z = Endosymbionts_Sets[1:10],
                  Verbose = TRUE)
                  

\donttest{
# extract just the pairs
Sets <- ExtractBy(x = Endosymbionts_Pairs03,
                  y = DBPATH,
                  Verbose = TRUE)
}
}
