\name{plotRTCor}
\alias{plotRTCor}
\title{Plot for retention time correlation of two libraries}
\usage{
plotRTCor(dat1, dat2, label1, label2, nomod = FALSE)
}
\arguments{
\item{dat1}{A data frame containing the first spectrum library}

\item{dat2}{A data frame containing the second spectrum library}

\item{label1}{a character string representing the x axis label for plotting}

\item{label2}{a character string representing the y axis label for plotting}

\item{nomod}{a logic value, representing if the modified peptides and its
fragment ions will be removed. FALSE (default) means not removing.}
}
\description{
Plot for retention time correlation of two libraries
}
\value{
retentiont time correlation coefficient
}
\examples{
libfiles <- paste(system.file("files",package="SwathXtend"),
   c("Lib2.txt","Lib3.txt"),sep="/")
datBaseLib <- readLibFile(libfiles[1])
datExtLib <- readLibFile(libfiles[2])
plotRTCor(datBaseLib, datExtLib, "Lib2", "Lib5")
}

