
\name{plotRIICor}
\alias{plotRIICor}
\title{Plot relative ion intensity correlation of two libraries}
\usage{
plotRIICor(dat1, dat2, nomod = FALSE)
}
\arguments{
\item{dat1}{A data frame containing the first spectrum library}

\item{dat2}{A data frame containing the second spectrum library}

\item{nomod}{a logic value, representing if the modified peptides and its
fragment ions will be removed. FALSE (default) means not removing.}
}
\description{
Plot relative ion intensity correlation of two libraries
}
\value{
a data frame of relative ion intensity correlations for all ions
}
\examples{
libfiles <- paste(system.file("files",package="SwathXtend"),
   c("Lib2.txt","Lib3.txt"),sep="/")
datBaseLib <- readLibFile(libfiles[1])
datExtLib <- readLibFile(libfiles[2])
plotRIICor(datBaseLib, datExtLib)
}

