\name{mlrGroup}
\alias{mlrGroup}
\title{
Function to do mlr normalization for a matrix group
}
\description{
Do mlr normalization separately for each set of replicates first, then normalize the resulting matrix
}
\usage{
mlrGroup(mat, Group)
}
\arguments{
  \item{mat}{
	Data matrix with replicates as columns
}
  \item{Group}{
	Factor of length ncol(mat)
}
}
\details{

}
\value{
Resulting normalized matrix of the same size as the initial one
}
\references{
*Find reference to mlr paper*
}
\author{
}
\note{
}
\seealso{
\code{\link{mlrrep}}, \code{\link{mlr}}
}
\examples{

res = mlrGroup(iris[,-5], Group=as.factor(c("Sepal", "Sepal", "Petal", "Petal")))

layout(matrix(1:3, nrow=1))
boxplot(log(iris[,-5]), main="Log only")
boxplot(log(medianNorm(iris[,-5])), main="Median")
boxplot(log(res[[1]]), main="MLR")


}

