plotRelativeDensities <-
function(mat, Group=NULL, idx=NULL, main="Densities") {

n = ncol(mat)
if (is.null(Group)) Group = rep("A", ncol(mat))
Group = as.factor(Group)

if (is.null(idx)) idx = 1;
C = rainbow(nlevels(Group))[Group]

# empty plot
plot(density(log(na.omit(mat[,1]))), type="n", ylim=c(0,2), xlim=c(-5,5), main=main)
abline(v=0, col="blue")

# calculate all relative ratios
for (i in 1:n) {
	 if (i != idx) lines(density(log(na.omit(mat[,i]/mat[,idx]))), col=C[i]);
}

}
