###########################################################################
#' Plot residuals for retention time prediction of two libraries
#' @param dat1 A data frame containing the first spectrum library
#' @param dat2 A data frame containing the second spectrum library
#' @param nomod a logic value, representing if the modified peptides and its
#' fragment ions will be removed. FALSE (default) means not removing.
#' @examples 
#' libfiles <- paste(system.file("files",package="SwathXtend"),
#'    c("Lib2.txt","Lib3.txt"),sep="/")
#' datBaseLib <- readLibFile(libfiles[1])
#' datExtLib <- readLibFile(libfiles[2])
#' plotRTResd(datBaseLib, datExtLib)
############################################################################ 

plotRTResd <- function(dat1, dat2, nomod=FALSE) {
	datRTrain <- getRTrain(dat1, dat2, nomod=nomod)
	bestModel <- selectModel(datRTrain)
	predicted <- predict(bestModel, newdata=datRTrain)
	rmse <- sqrt(mean((datRTrain[,2]-predicted)^2)) 
	resids <- predicted-datRTrain[,2]
	plot(resids, main=paste("Residual plot for",
						  attr(bestModel,"class")[length(attr(bestModel,"class"))]))
	abline(h=floor(rmse),col="red")
	abline(h=-floor(rmse), col="red")
	axis(2, c(-floor(rmse),floor(rmse)), col.ticks="red")
	rmselabel <- bquote(italic(rmse) ==. (format(rmse, digits=2)))
	text(2, max(resids), labels = rmselabel, pos=4)

	invisible(rmse)
}