
###########################################################################
#' Plot statistical plots for two libraries
#' @param datBaseLib a data frame for a base spectrum library
#' @param datExtLib a data frame for a external spectrum library
#' @examples 
#' libfiles <- paste(system.file("files",package="SwathXtend"),
#' c("Lib2.txt","Lib3.txt"),sep="/") 
#' datBaseLib <- readLibFile(libfiles[1])
#' datExtLib <- readLibFile(libfiles[2])
#' plotAll(datBaseLib, datExtLib)
############################################################################     


plotAll <- function(datBaseLib, datExtLib, file="allplots.xlsx", ...)
{
  wb <- createWorkbook()
  
  # plot stats
  addWorksheet(wb, sheetName="Library stats")
  
  pstats <- try(plotStats(datBaseLib, datExtLib, wb=wb, sheet="Library stats", ...))
  if(inherits(pstats, "try-error"))
    stop("Error with plotStats")  
   
  list.datLibs <- try(splitLib(datBaseLib, datExtLib))
  
  
  if(inherits(list.datLibs,"try-error"))
    stop("Error with splitting datExtLib")
  
  datExtLibCommPart <- list.datLibs[["ExtCommon"]]
  datBaseCommPart <- list.datLibs[["BaseCommon"]]
  
  # plot RT correlation
  addWorksheet(wb, sheetName="RT cor")
  rtcor <- try(computeRTCor(datBaseCommPart,datExtLibCommPart, wb=wb, sheet="RT cor"))
  if(inherits(rtcor,"try-error"))
    stop("Error with computeRTCor")
  
  
  
  # plot RII correlation
  
  addWorksheet(wb, sheetName="Relative Ion Intensity cor")
  
  ioncor<- try(computeRIICor(datBaseCommPart,datExtLibCommPart, wb=wb, sheet="Relative Ion Intensity cor"))
  if(inherits(ioncor,"try-error"))
    stop("Error with computeRIICor")
  
  
  saveWorkbook(wb, file=file, overwrite=TRUE)
  
  invisible(list(rtcor = rtcor, ioncor=ioncor) )
}