% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGE.R
\name{DGE}
\alias{DGE}
\title{DGE function}
\usage{
DGE(
  expression,
  metadata,
  Nreplica,
  design = "~condition",
  condition = "condition",
  TEST,
  CTRL,
  alpha = 0.05,
  FC_filt = 0,
  output_tsv = FALSE,
  output_filename = "DEGs.tsv"
)
}
\arguments{
\item{expression}{Dataframe with counts}

\item{metadata}{Dataframe with sample metadata}

\item{Nreplica}{Double. Minimum number of replicates in each group}

\item{design}{Design formula for DGE}

\item{condition}{Column of the metadata ti use for DGE results}

\item{TEST}{Character. sample name in metadata}

\item{CTRL}{Character. sample name in metadata}

\item{alpha}{Double. the significance cutoff used for optimizing the independent filtering (by default 0.1).
If the adjusted p-value cutoff (FDR) will be a value other than 0.1, alpha should be set to that value.}

\item{FC_filt}{Dataframe with counts}

\item{output_tsv}{Logical. If \code{TRUE}, outputs a tsv file with the results. By default, FALSE.}

\item{output_filename}{Name of the tsv output file. Default is DEGs.tsv.}
}
\value{
A dataframe with \code{DEGs}
}
\description{
Perform Differential Gene Expression Analysis of RNA-Seq Data
}
\examples{
\dontrun{
# Simulation of bulk RNA data
countData <- matrix(floor(runif(10000, min=0, max=101)),ncol=4)
colnames(countData) <- paste("sample", seq_len(ncol(countData)), sep = "")
rownames(countData) <- paste("gene", seq_along(seq_len(10000/4)), sep = "")
metadata <- data.frame(samplesID = paste("sample", seq_len(ncol(countData)), sep = ""),
                       condition = factor(c("A","A","B","B")))
row.names(metadata) <- metadata$samplesID
# Perform DGE
DGEresults <- DGE(expression = countData, metadata = metadata,
                 Nreplica = 2,
                 design = "~condition",condition = "condition",
                 TEST = "A", CTRL = "B")}
}
