% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerQualityControl.R
\name{markerQualityControl}
\alias{markerQualityControl}
\title{Evaluate the quality of the marker proteins}
\usage{
markerQualityControl(coveredProteins, protein.data)
}
\arguments{
\item{coveredProteins}{character; list of marker proteins, gene
symbols, that are covered in 3365 marker proteins.}

\item{protein.data}{data.frame; fractionated proteomics data,
rownames are gene symbols associated protein.}
}
\value{
robustMarkers
}
\description{
Given the proteomics data, quality of the overlapped
marker proteins are evaluated by correlating replicates of fractions.
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

r.markers <- markerQualityControl(c.prots[1:5], df)
}
}
