% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCls.R
\name{compareCls}
\alias{compareCls}
\title{Compare exon and gene centric classifications}
\usage{
compareCls(geneCls, exonCls)
}
\arguments{
\item{geneCls, }{data frame gene centric classification output}

\item{exonCls, }{data frame exon centric classification output}
}
\value{
c.df
}
\description{
Comparison of the gene centric and exon
centric classification. Additionally, correlation analysis
is performed using quantification data.
}
\examples{
{

exon.cls <- data.frame(Protein = c("ENSE00000331854",
                                     "ENSE00000331855",
                                     "ENSE00000331859"),
                         NeighborhoodCls = c("Cytosol",
                                      "Cytosol",
                                      "Cytosol"),
                         CompartmentCls = c("C1","C1","C1"),
                         Secretory = c(0.1, 0.1, 0.1),
                         Nuclear = c(0.2, 0.2, 0.2),
                         Cytosol = c(0.2, 0.2, 0.2),
                         Mitochondria = c(0.2, 0.2, 0.2),
                         S1 = c(0.2, 0.2, 0.2),
                         S2 = c(0.2, 0.2, 0.2),
                         S3 = c(0.2, 0.2, 0.2),
                         S4 = c(0.2, 0.2, 0.2),
                         N1 = c(0.2, 0.2, 0.2),
                         N2 = c(0.2, 0.2, 0.2),
                         N3 = c(0.2, 0.2, 0.2),
                         N4 = c(0.2, 0.2, 0.2),
                         C1 = c(0.2, 0.2, 0.2),
                         C2 = c(0.2, 0.2, 0.2),
                         C3 = c(0.2, 0.2, 0.2),
                         C4 = c(0.2, 0.2, 0.2),
                         C5 = c(0.2, 0.2, 0.2),
                         M1 = c(0.2, 0.2, 0.2),
                         M2 = c(0.2, 0.2, 0.2),
                         GeneSymbol = c("COPB1", "COPB1", "COPB1"),
                         PeptideCount = c(2, 4, 7))

gene.cls <- data.frame(Protein = c("COPB1"),
NeighborhoodCls = c("Cytosol"),
CompartmentCls = c("C1"),
Secretory = c(0.1),
Nuclear = c(0.2),
Cytosol = c(0.2),
Mitochondria = c(0.2),
S1 = c(0.2),
S2 = c(0.2),
S3 = c(0.2),
S4 = c(0.2),
N1 = c(0.2),
N2 = c(0.2),
N3 = c(0.2),
N4 = c(0.2),
C1 = c(0.2),
C2 = c(0.2),
C3 = c(0.2),
C4 = c(0.2),
C5 = c(0.2),
M1 = c(0.2),
M2 = c(0.2))

comp.df <- compareCls(gene.cls, exon.cls)

}
}
