% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Konditional.R
\name{Kontextual}
\alias{Kontextual}
\title{Evaluation of pairwise cell relationships, conditional on a 3rd population.}
\usage{
Kontextual(
  cells,
  r,
  parentDf = NULL,
  from = NULL,
  to = NULL,
  parent = NULL,
  image = NULL,
  inhom = FALSE,
  edgeCorrect = TRUE,
  window = "convex",
  window.length = NA,
  includeOriginal = TRUE,
  spatialCoords = c("x", "y"),
  cellType = "cellType",
  imageID = "imageID",
  cores = 1
)
}
\arguments{
\item{cells}{A SingleCellExperiment, SpatialExperiment or a list of
data.frames containing columns specifying the imageID, cellType, and x and y
spatial coordinates.}

\item{r}{Radii to evaluated pairwise relationships between from and to cells.}

\item{parentDf}{A data frame from \code{\link[Statial]{parentCombinations}}}

\item{from}{The first cell type to be evaluated in the pairwise relationship.}

\item{to}{The second cell type to be evaluated in the pairwise relationship.}

\item{parent}{The parent population of the from cell type (must include from cell type).}

\item{image}{A vector of images to subset the results to. If NULL we default to all images.}

\item{inhom}{A logical value indicating whether to account for inhomogeneity.}

\item{edgeCorrect}{A logical value indicating whether to perform edge correction.}

\item{window}{Type of window for data, either `square`, `convex` or `concave`,
passed into \code{\link[Statial]{makeWindow}}}

\item{window.length}{A tuning parameter for controlling the level of concavity when estimating concave windows.
Passed into \code{\link[Statial]{makeWindow}}}

\item{includeOriginal}{A logical value to return the original L function
values along with the kontextual values.}

\item{spatialCoords}{The columns which contain the x and y spatial coordinates.}

\item{cellType}{The column which contains the cell types.}

\item{imageID}{The column which contains image identifiers.}

\item{cores}{Number of cores for parallel processing.}
}
\value{
A kontextualResult object
}
\description{
Kontextual identifies the relationship between two cell types which are
conditional on the spatial behaviour of a 3rd cell population, for a
particular radius (r).
}
\examples{
# Load data
data("kerenSCE")


CD4_Kontextual <- Kontextual(
  cells = kerenSCE,
  r = 50,
  from = "Macrophages",
  to = "Keratin_Tumour",
  parent = c("Macrophages", "CD4_Cell"),
  image = "6"
)


head(CD4_Kontextual)

}
