% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLADE_deconvolution.R
\name{BLADE_deconvolution}
\alias{BLADE_deconvolution}
\title{Run BLADE deconvolution}
\usage{
BLADE_deconvolution(
  signature,
  bulk,
  genes,
  prior = NULL,
  cores = 1L,
  Alpha = 1L,
  Alpha0 = 1000L,
  Kappa0 = 1L,
  sY = 1L,
  Nrep = 10L,
  Nrepfinal = 1000L
)
}
\arguments{
\item{signature}{SimpleList with mu and sigma, both nGene x nCelltype
dataframes, respectively mean gene expression and mean-variance corrected
variance per cell type}

\item{bulk}{nSample x nGene mRNA to be deconvolved}

\item{genes}{subset of genes to be used for deconvolution}

\item{prior}{(optional) nSample x nCelltype matrix with prior fraction
expectations}

\item{cores}{number of cores to use for paralellization}

\item{Alpha}{BLADE Hyperparameter}

\item{Alpha0}{BLADE Hyperparameter}

\item{Kappa0}{BLADE Hyperparameter}

\item{sY}{BLADE Hyperparameter}

\item{Nrep}{Number of BLADE initializations}

\item{Nrepfinal}{Number of maximum optimization iterations}
}
\value{
SummarizedExperiment object with BLADE output and estimated fractions
}
\description{
\code{BLADE_deconvolution.R} Runs BLADE to estimate cell fractions from bulk
mRNA
}
\examples{
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(scRNAseq)
    library(scuttle)
    ## Load SegerstolpePancreas data set
    scRNAseq <- SegerstolpePancreasData()

    ## remove duplicate genes
    scRNAseq <- scRNAseq[!duplicated(rownames(scRNAseq)), ]
    ## Subset to 1 healthy and 2 type 2 diabetes samples
    scRNAseq = scRNAseq[,scRNAseq$individual \%in\% c('H3',
                                               'T2D1', 'T2D2')]
    ## remove cells with no cell type label
    scRNAseq <- scRNAseq[, !is.na(scRNAseq$`cell type`)]

    ## remove very rare cell types (<100 cells in total data set)
    celltypes_to_remove <- names(table(scRNAseq$`cell type`)
        [(table(scRNAseq$`cell type`) < 100)])
    scRNAseq <- scRNAseq[, !scRNAseq$`cell type` \%in\% celltypes_to_remove]

    ## Create pseudobulk and normalize to cp10k
    pseudobulk <- aggregateAcrossCells(scRNAseq, ids = scRNAseq$individual)
    normcounts(pseudobulk) <- calculateCPM(pseudobulk)/100
    pseudobulk = as(pseudobulk, "SummarizedExperiment")
    rownames(pseudobulk) = rownames(scRNAseq)

    ## Load signature
    load(system.file("extdata", "example_signature.RData",
        package = "StatescopeR"))

    ## Load selected_genes
    load(system.file("extdata", "example_selected_genes.RData",
        package = "StatescopeR"))

    ##  Load prior
    load(system.file("extdata", "example_prior.RData",
        package = "StatescopeR"))

    ## Perform Deconvolution with BLADE
    Statescope <- BLADE_deconvolution(
        signature, pseudobulk, selected_genes,
        prior, 1L,
        Nrep = 1L)

    ## show estimated fractions
    S4Vectors::metadata(Statescope)$fractions
    }
}
