% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localOutliers.R
\name{localOutliers}
\alias{localOutliers}
\title{localOutliers Function}
\usage{
localOutliers(
  spe,
  metric = "detected",
  direction = "lower",
  n_neighbors = 36,
  samples = "sample_id",
  log = TRUE,
  cutoff = 3,
  workers = 1
)
}
\arguments{
\item{spe}{SpatialExperiment or SingleCellExperiment object}

\item{metric}{colData QC metric to use for outlier detection}

\item{direction}{Direction of outlier detection (higher, lower, or both)}

\item{n_neighbors}{Number of nearest neighbors to use for outlier detection}

\item{samples}{Column name in colData to use for sample IDs}

\item{log}{Logical indicating whether to log1p transform the features
(default is TRUE)}

\item{cutoff}{Cutoff for outlier detection (default is 3)}

\item{workers}{Number of workers for parallel processing (default is 1)}
}
\value{
SpatialExperiment or SingleCellExperiment object with updated colData containing outputs
}
\description{
This function detects local outliers in spatial transcriptomics data based on
standard quality control metrics, such as library size, unique genes, and
mitochondrial ratio. Local outliers are defined as spots with low/high
quality metrics compared to their surrounding neighbors, based on a modified
z-score statistic.
}
\examples{
library(SpotSweeper)
library(SpatialExperiment)

# load example data
spe <- STexampleData::Visium_humanDLPFC()

# change from gene id to gene names
rownames(spe) <- rowData(spe)$gene_name

# drop out-of-tissue spots
spe <- spe[, spe$in_tissue == 1]
spe <- spe[, !is.na(spe$ground_truth)]

# Identifying the mitochondrial transcripts in our SpatialExperiment.
is.mito <- rownames(spe)[grepl("^MT-", rownames(spe))]

# Calculating QC metrics for each spot using scuttle
spe <- scuttle::addPerCellQCMetrics(spe, subsets = list(Mito = is.mito))
colnames(colData(spe))

# Identifying local outliers using SpotSweeper
spe <- localOutliers(spe,
                     metric = "sum",
                     direction = "lower",
                     log = TRUE
)

}
