% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_seurat.R
\name{convertToSeurat}
\alias{convertToSeurat}
\title{Convert slide object to Seurat object}
\usage{
convertToSeurat(slide_obj, image_dir, slice = "slice1", filter_matrix = TRUE)
}
\arguments{
\item{slide_obj}{A slide object created or inherited from
\code{createSlide()}.}

\item{image_dir}{(chr) Path to directory with 10X Genomics visium image data;
should include files \code{tissue_lowres_image.png},
\code{scalefactors_json.json} and \code{tissue_positions_list.csv}.}

\item{slice}{(chr) Name for the stored image of the tissue slice.
Default: "slice1"}

\item{filter_matrix}{(logical) If \code{TRUE}, only keep spots that have been
determined to be over tissue. If \code{slide_obj} only contains tissue spots,
\code{filter_matrix} has to be set \code{TRUE}. If \code{slide_obj}
contains both tissue and background spots, setting \code{filter_matrix=TRUE}
will subset the expression matrix to tissue spots only. Default: \code{TRUE}}
}
\value{
A Seurat object with spatial information.
}
\description{
This function converts our slide object of class
\code{SummarizedExperiment} to Seurat object of class \code{Seurat} so that
users can directly proceed with Seurat spatial analyses pipelines.
Built based on Seurat's \code{Load10X_Spatial()}.
}
\examples{

# load count matrix and slide metadata
data(mbrain_raw)
spatial_dir <- system.file(file.path("extdata",
                                     "V1_Adult_Mouse_Brain_spatial"),
                           package = "SpotClean")
mbrain_slide_info <- read10xSlide(tissue_csv_file=file.path(spatial_dir,
                                       "tissue_positions_list.csv"),
             tissue_img_file = file.path(spatial_dir,
                                       "tissue_lowres_image.png"),
             scale_factor_file = file.path(spatial_dir,
                                       "scalefactors_json.json"))

# Create slide object
mbrain_obj <- createSlide(mbrain_raw,
                          mbrain_slide_info)

# Convert to Seurat object
seurat_obj <- convertToSeurat(mbrain_obj, spatial_dir, "raw")
str(seurat_obj)

}
