% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_functions.R
\name{calculate_gini}
\alias{calculate_gini}
\title{Calculate Gini coefficient for a vector of transcript-level
expression values of one gene.}
\usage{
calculate_gini(x)
}
\arguments{
\item{x}{Vector of expression values.}
}
\value{
A single gene-level Gini coefficient.
}
\description{
Calculate Gini coefficient for a vector of transcript-level
expression values of one gene.
}
\details{
The function calculates a Gini coefficient as part of different
diversity calculations. Given a vector of transcript-level expression values
of a gene, this function characterize the diversity of splicing isoforms for
a gene. If there only one single transcript, the resulted index will be NaN,
as diversity cannot be calculated. If the expression of the given gene is 0,
the diversity index will be NA.
}
\examples{
# read counts for the transcripts of a single gene with 5 transcripts
x <- rnbinom(5, size = 10, prob = 0.4)
# calculate Gini index
gini <- calculate_gini(x)
}
