% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dash.R
\name{Graphics-User-Interface}
\alias{Graphics-User-Interface}
\alias{GUI}
\alias{spliceWiz}
\title{Launches the SpliceWiz Graphics User Interface (GUI) using Shiny Dashboard}
\usage{
spliceWiz(
  mode = c("dialog", "browser"),
  res = c("1080p", "720p", "960p", "1440p"),
  demo = FALSE
)
}
\arguments{
\item{mode}{(default \code{"dialog"}) \code{"dialog"} displays SpliceWiz in a dialog
box with specified width and height. \code{"browser"} opens SpliceWiz in a
browser-like resizable window.}

\item{res}{(default "1080p") Sets width and height of the app to pre-defined
dimensions. Possible options are "720p, "960p", "1080p", "1440p", which
specifies the height of the app. All are displayed in aspect ratio 16x9}

\item{demo}{(default FALSE) If set to \code{TRUE}, SpliceWiz will place demo
reference and BAM files into the temporary directory.}
}
\value{
Runs an interactive shinydashboard SpliceWiz app with the specified
mode.
}
\description{
This function launches the SpliceWiz interactive app using Shiny Dashboard
This is (by default) a dialog window within the RStudio application with
the resolution specified by the \code{res} parameter. Alternatively, setting
\code{mode = "browser"} will launch a resizable browser window (using the default
internet browser). The demo mode can be launched by setting \code{demo = TRUE}.
See the \href{../doc/SW_QuickStart.html}{SpliceWiz Quick-Start} for a guide
to using the SpliceWiz GUI.
}
\section{Functions}{
\itemize{
\item \code{spliceWiz()}: Launches the SpliceWiz GUI

}}
\examples{
if(interactive()) {

# Launches interactive ShinyDashboard SpliceWiz app as fixed-size dialog box
# 1080p = 1920 x 1080 pixels
    spliceWiz(mode = "dialog", res = "1080p") 

# Launches interactive ShinyDashboard SpliceWiz app as browser window
    spliceWiz(mode = "browser")

}

}
