% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/ASEFilter-methods.R
\docType{class}
\name{ASEFilter-class}
\alias{ASEFilter-class}
\alias{ASEFilter}
\title{SpliceWiz filters to remove low-confidence alternative splicing and intron
retention events}
\usage{
ASEFilter(
  filterClass = c("Data", "Annotation"),
  filterType = c("Depth", "Participation", "Consistency", "Modality", "Protein_Coding",
    "NMD", "TSL", "Terminus", "ExclusiveMXE", "StrictAltSS"),
  pcTRUE = 100,
  minimum = 20,
  maximum = 1,
  minDepth = 5,
  condition = "",
  minCond = -1,
  EventTypes = c("IR", "MXE", "SE", "A3SS", "A5SS", "AFE", "ALE", "RI")
)
}
\arguments{
\item{filterClass}{Must be either \code{"Data"} or \code{"Annotation"}. See details}

\item{filterType}{Must be a valid \code{"Data"} or \code{"Annotation"} filter. See
details}

\item{pcTRUE}{If conditions are set, what percentage of all samples in each
of the condition must satisfy the filter for the event to pass the
filter check. Must be between 0 and 100 (default 100)}

\item{minimum}{Filter-dependent argument. See details}

\item{maximum}{Filter-dependent argument. See details}

\item{minDepth}{Filter-dependent argument. See details}

\item{condition}{(default "") If set, must match the name of an experimental
condition in the NxtSE object to be filtered,
i.e. a column name in \code{colData(se)}. Leave blank to disable filtering
by condition}

\item{minCond}{(default -1) If condition is set, how many minimum number of
conditions must pass the filter criteria. For example,
if condition = "Batch", and batches are "A", "B", or "C", setting
\code{minCond = 2} with \code{pcTRUE = 100} means that all samples belonging to
two of the three types of \code{Batch} must pass the filter criteria.
Setting \code{-1} means all elements of \code{condition} must
pass criteria. Set to \code{-1} when the number of elements in the experimental
condition is unknown. Ignored if \code{condition} is left blank.}

\item{EventTypes}{What types of events are considered for filtering. Must be
one or more of \code{c("IR", "MXE", "SE", "A3SS", "A5SS", "AFE", "ALE", "RI")}.
Events not specified in \code{EventTypes} are not filtered (i.e. they will pass
the filter without checks)}
}
\value{
An ASEFilter object with the specified parameters
}
\description{
SpliceWiz implements a number of novel filters designed to exclude
alternative splicing events (ASEs) that yield low-confidence estimates.
}
\details{
\strong{Annotation Filters}
\itemize{
\item \strong{Modality}: Filters for specific modalities of ASEs. All events
belonging to the specified \code{EventTypes} are removed.
No additional parameters required.
\item \strong{Protein_Coding}: Filters for alternative splicing or IR events
involving protein-coding transcripts.
No additional parameters required.
\item \strong{NMD}: Filters for events in which one isoform is a
predicted NMD substrate.
\item \strong{TSL}: filters for events in which both
isoforms have a TSL level below or equal to \code{minimum}
\item \strong{Terminus}:
In alternate first exons, the splice junction must
not be shared with another transcript for which it is not its first
intron. For alternative last exons, the splice junction must not be
shared with another transcript for which it is not its last intron
\item \strong{ExclusiveMXE}:
For MXE events, the two alternate
casette exons must not overlap in their genomic regions
\item \strong{StrictAltSS}:
For A5SS / A3SS events, the two alternate splice sites must not be
interupted by detected introns
}

\strong{Data Filters}
\itemize{
\item \strong{Depth}: Filters IR or alternative splicing events of transcripts
that are "expressed" with adequate \code{Depth} as calculated by the
sum of all splicing and IR reads spanning the event. Events with
\code{Depth} below \code{minimum} are filtered out
\item \strong{Participation}: Participation means different things to IR
and alternative splicing.\cr\cr
For \strong{IR}, Participation refers to the percentage of the measured intron
covered with reads. Only introns of samples with a depth of intron
coverage (intron depth) above
\code{minDepth} are assessed, where introns with coverage percentage
below \code{minimum} are filtered out.\cr\cr
For \strong{non-IR ASEs}, Participation refers to the percentage of
all splicing events observed across the genomic region
(SpliceOver metric) that is
compatible with either the included or excluded event. This prevents
SpliceWiz from doing differential analysis between two minor isoforms.
Instead of IntronDepth, in AS events SpliceWiz considers events where
the SpliceOver metric exceed \code{minDepth}.
Then, events with a SpliceOver metric below \code{minimum}
are excluded. \cr\cr
We recommend testing IR events for > 70\% coverage and AS
events for > 40\% coverage as given in the default filters which can be
accessed using \link{getDefaultFilters}\cr\cr
\item \strong{Consistency}: Skipped exons (SE) and mutually exclusive exons
(MXE) comprise reads aligned to two contiguous splice junctions.
Most algorithms take the average counts from both junctions. This
will inadvertently include transcripts that share one but not both
splice events. To check that this is not happening, we require both
splice junctions to have comparable counts.
This filter checks whether reads from each splice junction comprises
a reasonable proportion of the sum of these reads.\cr\cr
Events are excluded if either of the upstream or downstream
event is lower than total splicing events by a log-2 magnitude
above \code{maximum}. For example, if
\code{maximum = 2}, we require both upstream and downstream
events to represent at least 1/(2^2) = 1/4 of the sum of upstream
and downstream event. If \code{maximum = 3}, then each junction must be at
least 1/8 of total, etc.
This is considered for each isoform of each event, and is NOT tested
when total (upstream+downstream) counts belonging to each isoform is
below \code{minDepth}.\cr\cr
IR-events are also checked. For IR events, the upstream and downstream
exon-intron spanning reads must comprise a reasonable proportion of total
exon-intron spanning reads.
}

We highly recommend using the default filters, which can be acquired
using \link{getDefaultFilters}
}
\section{Functions}{
\itemize{
\item \code{ASEFilter()}: Constructs a ASEFilter object

}}
\examples{
# Create a ASEFilter that filters for protein-coding ASE
f1 <- ASEFilter(filterClass = "Annotation", filterType = "Protein_Coding")

# Create a ASEFilter that filters for Depth >= 20 in IR events
f2 <- ASEFilter(
    filterClass = "Data", filterType = "Depth",
    minimum = 20, EventTypes = c("IR", "RI")
)

# Create a ASEFilter that filters for Participation > 60\% in splice events
# that must be satisfied in at least 2 categories of condition "Genotype"
f3 <- ASEFilter(
    filterClass = "Data", filterType = "Participation",
    minimum = 60, EventTypes = c("MXE", "SE", "AFE", "ALE", "A3SS", "A5SS"),
    condition = "Genotype", minCond = 2
)

# Create a ASEFilter that filters for Depth > 10 in all events
# that must be satisfied in at least 50\% of each gender
f4 <- ASEFilter(
    filterClass = "Data", filterType = "Depth",
    minimum = 10, condition = "gender", pcTRUE = 50
)

# Get a description of what these filters do:
f1
f2
f3
f4

}
\seealso{
\link{Run_SpliceWiz_Filters}
}
