% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R, R/utilities.R
\name{triu}
\alias{triu}
\alias{tril}
\alias{triu2diag}
\title{Functions for triangular matrices}
\usage{
triu(x, k = 1)

triu(x, k = 1)

tril(x, k = 1)

triu2diag(x, diagval = 0)
}
\arguments{
\item{x}{the data matrix or vector}

\item{k}{(0/1 flag indicate diagonal should be selected)}

\item{diagval}{value to be added to the diagonal if converting from upper triangular matrix.}
}
\value{
Upper triangular elements of matrix

Upper triangular elements of matrix
}
\description{
Get or symmeterize the upper/lower triangle of a symmetric matrix with the other side zeroed out
}
\examples{
# Create a symmetric matrix
mat <- matrix(1:16, 4, 4)
mat <- mat + t(mat)  # Make symmetric
# Get upper triangular elements
upper_elements <- triu(mat)
}
\keyword{internal}
