% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistr.R
\name{synth_comm_from_counts}
\alias{synth_comm_from_counts}
\title{synth_comm_from_counts}
\usage{
synth_comm_from_counts(
  comm,
  mar = 2,
  distr,
  Sigma = cov(comm),
  params,
  n = nrow(comm),
  retParams = FALSE,
  ...
)
}
\arguments{
\item{comm}{community: matrix of counts}

\item{mar}{the sample margin of the community data matrix (1: rows, 2: cols)}

\item{distr}{distribution to fit (see fitdistr)}

\item{Sigma}{covariance structure (defaults to empirical cov of comm)}

\item{params}{optionally supply already fitted parameters}

\item{n}{number of samples (defaults to comm samples)}

\item{retParams}{if TRUE, return the fitted parameters}

\item{...}{additional parameters to parameter fitting}
}
\value{
community
}
\description{
from count data (ex HMP) fit parameters to OTU margins
and simulate a new community with those properties
}
\examples{
# Create a simple community matrix
comm <- matrix(rpois(20, lambda=5), nrow=4, ncol=5)
# Simulate new community using Poisson distribution
new_comm <- synth_comm_from_counts(comm, distr="pois")
# Simulate using negative binomial with custom parameters
params <- get_comm_params(comm, distr="negbin")
new_comm_nb <- synth_comm_from_counts(comm, distr="negbin", params=params)
}
