% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{stars.roc}
\alias{stars.roc}
\alias{stars.pr}
\title{stars.roc, stars.pr}
\usage{
stars.roc(optmerge, theta, verbose = TRUE, plot = TRUE, ll = 15)

stars.pr(optmerge, theta, verbose = TRUE, plot = TRUE, ll = 15)
}
\arguments{
\item{optmerge}{the optimal 'merge' matrix selected by stars}

\item{theta}{the true graph or precision matrix}

\item{verbose}{display messages}

\item{plot}{graph the output}

\item{ll}{number of points for the plot}
}
\value{
ROC curve object
}
\description{
Plot a ROC (reciever operator characteristic) or a Precision-Recall curve
along the stars 'confidence path'. Each edge is a number in [0,1],
which is on the fraction of inferred graphs over subsamples in which that edge
appeared in stars.
}
\examples{
# Create sample data and run spiec.easi
data(amgut1.filt)
est <- spiec.easi(amgut1.filt, method='glasso', nlambda=10)
# Create a simple true graph for demonstration
true_graph <- matrix(0, ncol(amgut1.filt), ncol(amgut1.filt))
true_graph[1,2] <- true_graph[2,1] <- 1
# Plot ROC curve
roc_result <- stars.roc(getOptMerge(est), true_graph)
}
