% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseLowRankICov.R
\name{sparseLowRankiCov}
\alias{sparseLowRankiCov}
\title{Sparse plus Low Rank inverse covariance}
\usage{
sparseLowRankiCov(data, npn = FALSE, verbose = FALSE, cor = FALSE, ...)
}
\arguments{
\item{data}{the n x p data matrix}

\item{npn}{flag to first fit nonparametric normal transform to the data}

\item{verbose}{flag to turn on verbose output}

\item{cor}{flag to use correlation matrix as the input (default: false - uses covariance)}

\item{...}{arguments to override default algorithm settings (see details)}
}
\description{
Select an inverse covariance matrix that is a sparse plus low rank decomposition.
}
\details{
This is a wrapper function for sparse plus low rank iCov estimations performed by a custom ADMM algorithm.

Therefore, arguments \code{...} should be named. Typically, these are for specifying a penalty parameter, \code{lambda}, or the number of penalties to use.
By default 10 pentalties are used, ranging logarithmically between \code{lambda.min.ratio}*MAX and MAX.
Max is the theoretical upper bound on \code{lambda} and us \code{max|S|}, the maximum absolute value in the data correlation matrix.
\code{lambda.min.ratio} is 1e-3 by default. Lower values of \code{lambda} require more memory/cpu time to compute, and sometimes huge will throw an error.

The argument \code{nlambda} determines the number of penalties - somewhere between 10-100 is usually good, depending on how the values of empirical correlation are distributed.#' @export

One of \code{beta} (penalty for the nuclear norm) or \code{r} (number of ranks) should be supplied or \code{r=2} is chosen by default.
}
\examples{
# simulate data with 1 negative correlation
 set.seed(10010)
 Sigma <- diag(10)*2
 Sigma[1,2] <- Sigma[2,1] <- -.9
 data  <- exp(rmvnorm(50, runif(10, 0, 2), Sigma))

# normalize
 data.f   <- t(apply(data, 1, norm_to_total))
 data.clr <- t(clr(data.f, 1))

# estimate
 est.clr  <- sparseLowRankiCov(data.clr, cor=TRUE, r=2)
 est.f    <- sparseLowRankiCov(data.f, cor=TRUE, r=2)
 est.log  <- sparseLowRankiCov(log(data), cor=TRUE, r=2)

# visualize results
 par(mfrow=c(1,3))
 image(as.matrix(est.log$path[[6]][1:5,1:5]))
 image(as.matrix(est.clr$path[[6]][1:5,1:5]))
 image(as.matrix(est.f$path[[6]][1:5,1:5]))
}
