% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaRcc.R
\name{sparccboot}
\alias{sparccboot}
\title{Bootstrap SparCC}
\usage{
sparccboot(
  data,
  sparcc.params = list(),
  statisticboot = function(data, indices) triu(do.call("sparcc", c(list(data[indices, ,
    drop = FALSE]), sparcc.params))$Cor),
  statisticperm = function(data, indices) triu(do.call("sparcc",
    c(list(apply(data[indices, ], 2, sample)), sparcc.params))$Cor),
  R,
  ncpus = 1,
  ...
)
}
\arguments{
\item{data}{Community count data}

\item{sparcc.params}{named list of parameters to pass to \code{sparcc}}

\item{statisticboot}{function which takes data and bootstrap sample indices and results the upper triangle of the bootstapped correlation matrix}

\item{statisticperm}{function which takes data and permutated sample indices and results the upper triangle of the null correlation matrix}

\item{R}{number of bootstraps}

\item{ncpus}{number of cores to use for parallelization}

\item{...}{additional arguments that are passed to \code{boot::boot}}
}
\description{
Get bootstrapped estimates of SparCC correlation coefficients. To get empirical p-values, pass this output to \code{pval.sparccboot}.
}
\examples{
# simulate data with 1 negative correlation
 set.seed(10010)
 Sigma <- diag(10)*2
 Sigma[1,2] <- Sigma[2,1] <- -.9
 data  <- exp(rmvnorm(50, runif(10, 0, 2), Sigma))

# estimate
 est.sparcc  <- sparccboot(data, R=100)
 mean(est.sparcc$t[,1]) # bootstrap estimate of true correlation
}
