% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvdistributions.R
\name{rzipois}
\alias{rzipois}
\title{Draw samples from a zero-inflated poisson distribution}
\usage{
rzipois(n, lambda, pstr0 = 0)
}
\arguments{
\item{n}{the number of samples to draw}

\item{lambda}{The poisson rate parameter}

\item{pstr0}{probability of drawing a zero}
}
\value{
Poisson counts of length \eqn{n}
}
\description{
Draw samples from a zero-inflated poisson distribution
}
\examples{
# Draw 10 samples from ZIP with lambda=5 and 20\% zero inflation
rzipois(10, lambda=5, pstr0=0.2)

# Draw 100 samples with different parameters
rzipois(100, lambda=c(2,5,8), pstr0=c(0.1,0.2,0.3))
}
