% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvdistributions.R
\name{rmvzipois}
\alias{rmvzipois}
\title{Generate multivariate, Zero-inflated poisson data,
with counts approximately correlated according to Sigma}
\usage{
rmvzipois(n, mu, Sigma = diag(length(mu)), lambdas, ps, ...)
}
\arguments{
\item{n}{number of samples to draw}

\item{mu}{mean vector for variables (of length \eqn{D})}

\item{Sigma}{\eqn{DxD} covariance or correlation matrix}

\item{lambdas}{supply rate parameter (instead of mu)}

\item{ps}{probability of zeros (instead of mu)}

\item{...}{arguments passed to \code{VGAM::qzipois}}
}
\value{
\eqn{Dxn} matrix with zi-poisson data
}
\description{
Generate multivariate, Zero-inflated poisson data,
with counts approximately correlated according to Sigma
}
\examples{
# Generate 50 samples from 3 correlated ZIP variables
mu <- c(2, 5, 8)
Sigma <- matrix(c(1, 0.5, 0.2, 0.5, 1, 0.3, 0.2, 0.3, 1), nrow=3)
data <- rmvzipois(50, mu=mu, Sigma=Sigma)

# Generate using explicit lambda and zero-inflation parameters
lambdas <- c(2, 5, 8)
ps <- c(0.1, 0.2, 0.3)
data2 <- rmvzipois(50, Sigma=Sigma, lambdas=lambdas, ps=ps)
}
