% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvdistributions.R
\name{rmvzinegbin}
\alias{rmvzinegbin}
\title{Generate multivariate, negative binomial data,
with counts approximately correlated according to Sigma}
\usage{
rmvzinegbin(n, mu, Sigma, munbs, ks, ps, ...)
}
\arguments{
\item{n}{number of samples to draw}

\item{mu}{mean vector for variables (of length \eqn{D})}

\item{Sigma}{\eqn{DxD} covariance or correlation matrix}

\item{munbs}{Rate/mean parameter (instead of mu)}

\item{ks}{shape parameter}

\item{ps}{probability of zero inflation}

\item{...}{other arguments to the negative binomial distribution}
}
\value{
\eqn{Dxn} matrix with zi-poisson data
}
\description{
Generate multivariate, negative binomial data,
with counts approximately correlated according to Sigma
}
\examples{
# Generate 50 samples from 3 correlated ZINB variables
mu <- c(2, 5, 8)
Sigma <- matrix(c(1, 0.5, 0.2, 0.5, 1, 0.3, 0.2, 0.3, 1), nrow=3)
data <- rmvzinegbin(50, mu=mu, Sigma=Sigma)

# Generate with explicit parameters
munbs <- c(2, 5, 8)
ks <- c(2, 3, 4)
ps <- c(0.1, 0.2, 0.3)
data2 <- rmvzinegbin(50, Sigma=Sigma, munbs=munbs, ks=ks, ps=ps)
}
