% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvdistributions.R
\name{rmvpois}
\alias{rmvpois}
\title{Generate multivariate poisson data,
with counts approximately correlated according to Sigma}
\usage{
rmvpois(n, mu, Sigma, ...)
}
\arguments{
\item{n}{number of samples to draw}

\item{mu}{mean vector for variables (of length \eqn{D})}

\item{Sigma}{\eqn{DxD} covariance or correlation matrix}

\item{...}{Arguments passed to \code{qpois}}
}
\value{
\eqn{Dxn} matrix with zi-poisson data
}
\description{
Generate multivariate poisson data,
with counts approximately correlated according to Sigma
}
\examples{
# Generate 50 samples from 3 correlated Poisson variables
mu <- c(2, 5, 8)
Sigma <- matrix(c(1, 0.5, 0.2, 0.5, 1, 0.3, 0.2, 0.3, 1), nrow=3)
data <- rmvpois(50, mu=mu, Sigma=Sigma)
}
