% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvdistributions.R
\name{rmvnorm}
\alias{rmvnorm}
\title{Draw samples from multivariate, correlated normal distribution
with counts correlated according to Sigma}
\usage{
rmvnorm(
  n = 100,
  mu = rep(0, 10),
  Sigma = diag(10),
  tol = 1e-06,
  empirical = TRUE
)
}
\arguments{
\item{n}{number of samples to draw}

\item{mu}{mean vector for variables (of length \eqn{D})}

\item{Sigma}{\eqn{DxD} covariance or correlation matrix}

\item{tol}{numerical tolerance for a zero eigenvalue (check for PD of Sigma)}

\item{empirical}{is Sigma the empirical correlation?}
}
\value{
\eqn{Dxn} matrix with Gaussian data
}
\description{
Draw samples from multivariate, correlated normal distribution
with counts correlated according to Sigma
}
\examples{
# Generate 50 samples from 3 correlated normal variables
mu <- c(0, 0, 0)
Sigma <- matrix(c(1, 0.5, 0.2, 0.5, 1, 0.3, 0.2, 0.3, 1), nrow=3)
data <- rmvnorm(50, mu=mu, Sigma=Sigma)

# Generate with different mean vector
mu2 <- c(1, 2, 3)
data2 <- rmvnorm(50, mu=mu2, Sigma=Sigma)
}
