% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistr.R
\name{qqdplot_comm}
\alias{qqdplot_comm}
\title{qq-plot for theoretical vs observed communities}
\usage{
qqdplot_comm(comm, distr, param, plot = TRUE, ...)
}
\arguments{
\item{comm}{commutity count matrix}

\item{distr}{character specifying target distribution}

\item{param}{parameter list for fitting the data. Output from \code{get_comm_params}}

\item{plot}{graph the output}

\item{...}{pass arguments to qqplot}
}
\value{
QQ plot object or fitted parameters
}
\description{
qq-plot for theoretical vs observed communities
}
\examples{
# Create a simple community matrix
comm <- matrix(rpois(100, lambda=5), nrow=10, ncol=10)
# Get parameters for Poisson distribution
params <- get_comm_params(comm, distr="pois")
# Create QQ plot
qqdplot_comm(comm, distr="pois", param=params)
}
