% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaRcc.R
\name{pval.sparccboot}
\alias{pval.sparccboot}
\title{SparCC p-vals}
\usage{
pval.sparccboot(x, sided = "both")
}
\arguments{
\item{x}{output from \code{sparccboot}}

\item{sided}{type of p-value to compute. Only two sided (sided="both") is implemented.}
}
\description{
Get empirical p-values from bootstrap SparCC output.
}
\examples{
# simulate data with 1 negative correlation
 set.seed(10010)
 Sigma <- diag(10)*2
 Sigma[1,2] <- Sigma[2,1] <- -.9
 data  <- exp(rmvnorm(50, runif(10, 0, 2), Sigma))

# estimate
 est.sparcc  <- sparccboot(data, R=100)
# find significant correlations
 out <- pval.sparccboot(est.sparcc)
 out$cors[out$pvals < .05]
}
