% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_graph.R
\name{prec2cov}
\alias{prec2cov}
\title{Precision matrix (inverse covariance) to a covariance matrix}
\usage{
prec2cov(Precision, tol = 1e-04)
}
\arguments{
\item{Precision}{symmetric precision matrix}

\item{tol}{tolerance to define a zero eigenvalue (ie - is Prec positive definite)}
}
\value{
A covariance matrix (inverse of the precision matrix)
}
\description{
Precision matrix (inverse covariance) to a covariance matrix
}
\examples{
# Create a simple precision matrix
prec <- matrix(c(2, -1, 0, -1, 2, -1, 0, -1, 2), nrow=3)
# Convert to covariance matrix
cov <- prec2cov(prec)
}
