% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseICov.R
\name{neighborhood.net}
\alias{neighborhood.net}
\title{Neighborhood net estimates}
\usage{
neighborhood.net(data, lambda, method = "ising", ncores = 1, sym = "or", ...)
}
\arguments{
\item{data}{n x p input (pre-transformed) data}

\item{lambda}{the lambda path}

\item{method}{ising and poisson models currently supported.}

\item{ncores}{number of cores for distributing the model fitting}

\item{sym}{symmetrize the neighborhood using the 'or' (default)/'and' rule}

\item{...}{further arguments to glmnet}
}
\value{
A sparse inverse covariance matrix estimated using neighborhood selection
}
\description{
Select a sparse inverse covariance matrix using neighborhood selection and glmnet from various exponential models.
}
\examples{
# Generate binary data for Ising model
set.seed(123)
data <- matrix(rbinom(100, 1, 0.5), nrow=20, ncol=5)
lambda <- c(0.1, 0.2, 0.3)

# Fit neighborhood selection model
result <- neighborhood.net(data, lambda, method="ising")

# Check adjacency matrices
length(result$path)  # Number of lambda values
}
