% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiec-easi.R
\name{multi.spiec.easi}
\alias{multi.spiec.easi}
\alias{spiec.easi.list}
\title{multi domain SPIEC-EASI}
\usage{
multi.spiec.easi(
  datalist,
  method = "glasso",
  sel.criterion = "stars",
  verbose = TRUE,
  pulsar.select = TRUE,
  pulsar.params = list(),
  ...
)

\method{spiec.easi}{list}(data, ...)
}
\arguments{
\item{datalist}{list of non-normalized count OTU/data tables (stored in a matrix, data.frame or phyloseq/otu_table) with samples on rows and features/OTUs in columns}

\item{method}{estimation method to use as a character string. Currently either 'glasso' or 'mb' (meinshausen-buhlmann's neighborhood selection)}

\item{sel.criterion}{character string specifying criterion/method for model selection. Accepts 'stars' and 'bstars' [default]}

\item{verbose}{flag to show progress messages}

\item{pulsar.select}{flag to perform model selection. Choices are TRUE/FALSE/'batch'}

\item{pulsar.params}{list of further arguments to pulsar model selection. See the documentation for \code{\link{pulsar.params}}.}

\item{...}{further arguments to sparse inverse covariance estimation}

\item{data}{non-normalized count OTU/data table with samples on rows and features/OTUs in columns. Can also be list of phyloseq objects.}
}
\value{
a list of pulsar parameters.
}
\description{
A SPIEC-EASI pipeline for inferring a sparse inverse covariance matrix within and between multiple compositional datasets, under joint sparsity penalty.
}
\details{
Can also run \code{spiec.easi} on a list and S3 will dispatch the proper function.
}
\examples{
# Generate random data
data <- exp(matrix(rnorm(100), nrow=10))
data2 <- exp(matrix(rnorm(100, sd=2, mean=20), nrow=10))
datalist <- list(data, data2)
# Run SPIEC-EASI
result <- spiec.easi(datalist)

}
\seealso{
\code{\link{spiec.easi}}
}
