% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_graph.R
\name{make_graph}
\alias{make_graph}
\title{Procedure to generate graph topologies for Gaussian Graphical Models}
\usage{
make_graph(method, D, e, enforce = TRUE, ...)
}
\arguments{
\item{method}{Type of graph to make}

\item{D}{Number of nodes/OTUs (Graph dimension)}

\item{e}{Number of edges (preferably sparse, must be at least 1/2 D)}

\item{enforce}{add/remove edges to enforce graph has e edges}

\item{...}{additional options to graph method}
}
\value{
A symmetric adjacency matrix representing the graph topology
}
\description{
Procedure to generate graph topologies for Gaussian Graphical Models
}
\examples{
# Generate different types of graphs
g1 <- make_graph("erdos_renyi", D=10, e=15)
g2 <- make_graph("hub", D=10, e=15, numHubs=2)
g3 <- make_graph("scale_free", D=10, e=15)
g4 <- make_graph("cluster", D=10, e=15)
g5 <- make_graph("band", D=10, e=15)
g6 <- make_graph("block", D=10, e=15, numHubs=2)
}
