% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_graph.R
\name{graph2prec}
\alias{graph2prec}
\title{Convert a symmetric graph (extension of R matrix class)}
\usage{
graph2prec(
  Graph,
  posThetaLims = c(2, 3),
  negThetaLims = -posThetaLims,
  targetCondition = 100,
  epsBin = 0.01,
  numBinSearch = 100
)
}
\arguments{
\item{Graph}{graph adjacency matrix}

\item{posThetaLims}{length 2 vector of lower and upper bound of positive values}

\item{negThetaLims}{length 2 vector of lower and upper bound of negative values}

\item{targetCondition}{sets the condition of the precision matrix by modulating the magnitude of the diagonal}

\item{epsBin}{the convergence tolerance of the condition number binary search}

\item{numBinSearch}{maximum number of iterations}
}
\value{
A precision matrix with the specified condition number
}
\description{
Has internal rules for converting various graph topologies into the associated
adjancency and, therefore, precision matrix
}
\examples{
# Create a simple graph
g <- make_graph("erdos_renyi", D=10, e=15)
# Convert to precision matrix
prec <- graph2prec(g)
}
