% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistr.R
\name{get_comm_params}
\alias{get_comm_params}
\title{Get the parameters for the OTUs (along mar) of each community}
\usage{
get_comm_params(comm, mar = 2, distr, ...)
}
\arguments{
\item{comm}{community: matrix of counts}

\item{mar}{sample margin (1: "rows", 2: "cols")}

\item{distr}{distribution to fit (see fitdistr)}

\item{...}{arguments passed to fitdistr}
}
\value{
list of parameters
}
\description{
Get the parameters for the OTUs (along mar) of each community
}
\examples{
# Create a simple community matrix
comm <- matrix(rpois(20, lambda=5), nrow=4, ncol=5)
# Get parameters for Poisson distribution
params <- get_comm_params(comm, distr="pois")
# Get parameters for negative binomial distribution
params_nb <- get_comm_params(comm, distr="negbin")
}
