% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getOptInd}
\alias{getOptInd}
\alias{getOptLambda}
\alias{getOptMerge}
\alias{getStability}
\alias{getOptNet}
\alias{getRefit}
\alias{getOptBeta}
\alias{getOptCov}
\alias{getOptiCov}
\title{get StARS-optimal network}
\usage{
getOptInd(est)

getOptLambda(est)

getOptMerge(est)

getStability(est)

getOptNet(est)

getRefit(est)

getOptBeta(est)

getOptCov(est)

getOptiCov(est)
}
\arguments{
\item{est}{output from \code{spiec.easi}}
}
\value{
numeric or matrix associated with a StARS solution.
}
\description{
Get the optimal network, and related structures, when StARS is run.
}
\details{
Use the getter functions to parse \code{\link{spiec.easi}} output:

\itemize{
\item getOptLambda: penalty parameter from provided lambda path
\item getOptInd: index of the selected lambda from provided lambda path
\item getOptNet / getRefit: the optimal (StARS-refit) network
\item getStability: average stability at the selected sparsity
\item getOptMerge: symmetric matrix with edge-wise stability
\item getOptiCov: the optimal inverse covariance matrix (glasso only)
\item getOptCov: the optimal covariance matrix associated with the selected network (glasso only)
\item getOptBeta: the optimal coefficient matrix (mb only)
}
}
\examples{
# Get optimal index from spiec.easi result
data(amgut1.filt)
est <- spiec.easi(amgut1.filt, method='glasso', nlambda=10)
opt_idx <- getOptInd(est)
}
