% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{ebic}
\alias{ebic}
\title{Extended BIC}
\usage{
ebic(refit, data, loglik, gamma = 0.5)
}
\arguments{
\item{refit}{adjacency matrix, getOpt from SpiecEasi output}

\item{data}{input data set used to get the network}

\item{loglik}{log likeihood of the graphical model}

\item{gamma}{the model likeihood/complexity tradeoff parameter}
}
\value{
Extended BIC score
}
\description{
Calculate the extended BIC criterion on a sparse (refit) network and the input data
}
\examples{
# Generate a random adjacency matrix
refit <- matrix(rbinom(100, size=1, prob=0.5), nrow=10)

# Generate random data
data <- matrix(rnorm(100), nrow=10)

# Calculate log likelihood
loglik <- sum(dnorm(data, mean=0, sd=1, log=TRUE))

# Calculate extended BIC
ebic(refit, data, loglik)
}
