% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_graph.R
\name{cov2prec}
\alias{cov2prec}
\title{Covariance matrix to its matrix inverse (Precision matrix)}
\usage{
cov2prec(Cov, tol = 1e-04)
}
\arguments{
\item{Cov}{symmetric covariance matrix (can be correlation also)}

\item{tol}{tolerance to define a zero eigenvalue (ie - is Prec positive definite)}
}
\value{
A precision matrix (inverse of the covariance matrix)
}
\description{
Covariance matrix to its matrix inverse (Precision matrix)
}
\examples{
# Create a simple covariance matrix
cov <- matrix(c(1, 0.5, 0, 0.5, 1, 0.5, 0, 0.5, 1), nrow=3)
# Convert to precision matrix
prec <- cov2prec(cov)
}
