% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvdistributions.R
\name{cor2cov}
\alias{cor2cov}
\title{Convert a symmetric correlation matrix to a covariance matrix
given the standard deviation}
\usage{
cor2cov(cor, sds)
}
\arguments{
\item{cor}{a symmetric correlation matrix}

\item{sds}{standard deviations of the resulting covariance.}
}
\value{
Covariance matrix of sample dimension as cor
}
\description{
Convert a symmetric correlation matrix to a covariance matrix
given the standard deviation
}
\examples{
# Create a correlation matrix and standard deviations
cor <- matrix(c(1, 0.5, 0.2, 0.5, 1, 0.3, 0.2, 0.3, 1), nrow=3)
sds <- c(2, 3, 4)
# Convert to covariance matrix
cov <- cor2cov(cor, sds)
}
