% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{alr}
\alias{alr}
\alias{alr.default}
\alias{alr.matrix}
\alias{alr.data.frame}
\title{Additive log-ratio functions}
\usage{
alr(x.f, ...)

\method{alr}{default}(
  x.f,
  divcomp = 1,
  base = exp(1),
  removeDivComp = TRUE,
  tol = .Machine$double.eps,
  ...
)

\method{alr}{matrix}(
  x.f,
  mar = 2,
  divcomp = 1,
  base = exp(1),
  removeDivComp = TRUE,
  tol = .Machine$double.eps,
  ...
)

\method{alr}{data.frame}(x.f, mar = 2, ...)
}
\arguments{
\item{x.f}{input data}

\item{...}{pass through arguments}

\item{divcomp}{the index of the component to use as the divisor}

\item{base}{base for log transformation}

\item{removeDivComp}{remove the divisor component from the alr result}

\item{tol}{tolerance for a numerical zero}

\item{mar}{margin to apply the transformation (rows: 1 or cols: 2)}
}
\value{
Additive log-ratio transformed data
}
\description{
Additive log-ratio functions
}
\examples{
x <- c(1, 2, 3, 4)
alr(x)  # Returns additive log-ratio transformation using first component as reference

# Matrix example
mat <- matrix(1:12, nrow=3)
alr(mat)  # ALR transformation by columns

# Data frame example
df <- as.data.frame(mat)
alr(df)  # ALR transformation by columns
}
