% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNet.R
\name{adj2igraph}
\alias{adj2igraph}
\title{Adjacency to igraph}
\usage{
adj2igraph(
  Adj,
  rmEmptyNodes = FALSE,
  diag = FALSE,
  edge.attr = list(),
  vertex.attr = list(name = seq_len(ncol(Adj)))
)
}
\arguments{
\item{Adj}{an Adjacency matrix}

\item{rmEmptyNodes}{should unconnected nodes be removed from the graph}

\item{diag}{Flag to include self-loops (diagonal of adjacency matrix)}

\item{edge.attr}{named list of attributes for graph edges}

\item{vertex.attr}{named list of attributes for graph vertices}
}
\value{
An igraph object
}
\description{
Convert an adjacency matrix (ie - from the \code{sparseiCov} function) to an igraph object
}
\examples{
# Create a symmetric adjacency matrix
adj <- matrix(c(0, 1, 0, 1, 0, 1, 0, 1, 0), nrow=3, byrow=TRUE)

# Convert to igraph
g <- adj2igraph(adj, vertex.attr=list(name=c('A', 'B', 'C')))
}
