% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_boundary.R
\name{getTissueBoundaryImg}
\alias{getTissueBoundaryImg}
\title{Get tissue boundary from histology image}
\usage{
getTissueBoundaryImg(
  sfe,
  sample_id = NULL,
  image_id = NULL,
  image_type = c("brightfield", "fluorescent"),
  channel = NULL,
  n_pieces = 1,
  resolution = 4,
  maxcell = 1e+07,
  fill_holes = FALSE,
  simplify = TRUE,
  dTolerance = 0
)
}
\arguments{
\item{sfe}{An SFE object with images}

\item{sample_id}{Sample id(s) whose tissue boundaries are to be found.}

\item{image_id}{ID of image to use to get boundary.}

\item{image_type}{Character, either "brightfield" or "fluorescent"}

\item{channel}{Channel to use for tissue segmentation. If \code{NULL} use
average of all channels.}

\item{n_pieces}{Number of pieces; only this number of largest pieces are
kept. Smaller pieces will be considered debris and removed. Can be a vector
of the same length as \code{sample_id}, or if \code{sample_id} is "all"
then same length as the number of samples in the SFE object to specify
different number of pieces in different samples. If \code{n_pieces} is
length 1 while there are multiple samples, then the same number is applied
to all samples.}

\item{resolution}{Integer, which resolution to use for tissue boundary in a
pyramidal OME-TIFF stack. Only applicable to \code{BioFormatsImage}. Note
that the image will be loaded into memory and you usually don't need the
highest resolution for the tissue boundary.}

\item{maxcell}{Max number of pixels when loading \code{SpatRasterImage} into
memory.}

\item{fill_holes}{Logical, whether to fill holes in the tissue, to only get
the outer outline.}

\item{simplify}{Logical, whether to simplify the output polygon.}

\item{dTolerance}{Distance tolerance when simplifying the polygon, in the
same unit as the geometries in the SFE object.}
}
\value{
A \code{sf} data frame with columns \code{sample_id} and
  \code{geometry}.
}
\description{
This function gets the tissue boundary from image and makes sure that it is
properly aligned with the geometries in the SFE object.
}
