% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.R
\name{cbind,SpatialFeatureExperiment-method}
\alias{cbind,SpatialFeatureExperiment-method}
\title{Concatenate SpatialFeatureExperiment objects}
\usage{
\S4method{cbind}{SpatialFeatureExperiment}(..., deparse.level = 1)
}
\arguments{
\item{...}{SFE objects to cbind.}

\item{deparse.level}{See \code{?\link[base]{rbind}}.}
}
\value{
A combined SFE object.
}
\description{
On top of the \code{cbind} method of \code{SpatialExperiment}, this method is
needed to properly merge the \code{spatialGraphs} field in the different SFE
objects. \code{rowGeometries} and \code{annotGeometries} also need to be
combined properly.
}
\examples{
library(SFEData)
sfe_small <- McKellarMuscleData(dataset = "small")
sfe_small2 <- McKellarMuscleData(dataset = "small2")
sfe2 <- cbind(sfe_small, sfe_small2)
}
\concept{Non-spatial operations}
