% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{bbox,SpatialFeatureExperiment-method}
\alias{bbox,SpatialFeatureExperiment-method}
\alias{bbox}
\title{Find bounding box of SFE objects}
\usage{
\S4method{bbox}{SpatialFeatureExperiment}(sfe, sample_id = "all", include_images = FALSE, include_row = TRUE)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{sample_id}{Sample(s) whose bounding box(es) to find. The bounding box
would be for the union of all \code{colGeometries} and
\code{annotGeometries} associated with each sample.}

\item{include_images}{Logical, whether the bounding boxes should include
image extents. Defaults to \code{FALSE} because often the image has a lot
of empty space surrounding the tissue.}

\item{include_row}{Logical, whether the bounding boxes should include
\code{rowGeometries}, defaults to \code{TRUE}.}
}
\value{
For one sample, then a named vector with names \code{xmin},
  \code{ymin}, \code{xmax}, and \code{ymax} specifying the bounding box. For
  multiple samples, then a matrix whose columns are samples and whose rows
  delineate the bounding box.
}
\description{
Find bounding box of the union of all \code{colGeometries} and
\code{annotGeometries} of each sample in the SFE object. This can be used to
remove empty space so the tissue and geometries have one corner at the origin
so all samples will be on comparable coordinates.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
bbox(sfe, sample_id = "Vis5A")
}
\concept{Geometric operations}
