% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{SpatialExperiment-subset}
\alias{SpatialExperiment-subset}
\alias{[,SpatialExperiment,ANY,ANY,ANY-method}
\title{Subsetting SpatialExperiment objects}
\arguments{
\item{x}{a \code{\link{SpatialExperiment}} object}

\item{i}{row indices for subsetting}

\item{j}{column indices for subsetting}
}
\value{
a \code{\link{SpatialExperiment}} object
}
\description{
The subsetting method for \code{\link{SpatialExperiment}} objects ensures
that spatial data attributes (\code{\link{spatialCoords}} and
\code{\link{imgData}}) are subsetted correctly to match rows and columns with
the remainder of the object.
}
\section{subset}{

\describe{
\item{\code{[}:}{ subsetting method}
}
}

\examples{
example(SpatialExperiment)

dim(spe)

set.seed(123)
idx <- sample(ncol(spe), 10)
sub <- spe[, idx]
dim(sub)
colData(sub)
spatialCoords(sub)
}
