% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readStarmapplusSXE.R
\name{readStarmapplusSXE}
\alias{readStarmapplusSXE}
\title{Load data from a STARmap PLUS experiment}
\usage{
readStarmapplusSXE(
  dirName = dirName,
  returnType = "SPE",
  countMatPattern = "raw_expression_pd.csv",
  metaDataPattern = "spatial.csv",
  coordNames = c("X", "Y", "Z")
)
}
\arguments{
\item{dirName}{a directory path to STARmap PLUS download that contains files of interest.}

\item{returnType}{option of \code{"SPE"} or \code{"SCE"}, stands for
\code{SpatialExperiment} or \code{SingleCellExperiment} object. Default value \code{"SPE"}}

\item{countMatPattern}{a filename pattern for the count matrix. Default value is
\code{"raw_expression_pd.csv"}, and there is no need to change.}

\item{metaDataPattern}{a filename pattern for the metadata .csv file that
contains spatial coords. Default value is \code{"spatial.csv"}, and
there is no need to change.}

\item{coordNames}{a vector of three strings specify the spatial coord names.
Default value is \code{c("X", "Y", "Z")}, and there is no need to change.}
}
\value{
a \code{\link{SpatialExperiment}} or a \code{\link{SingleCellExperiment}} object
}
\description{
Creates a \code{\link{SpatialExperiment}} from the downloaded STARmap PLUS count
matrix.csv and metadata.csv
}
\details{
The constructor assumes the downloaded unzipped STARmap PLUS folder has the following
structure, with two mandatory files:
STARmap_PLUS_download/ \cr
· | — *raw_expression_pd.csv \cr
· | — *spatial.csv \cr
}
\examples{
# A relatively small data download can be from:
# https://zenodo.org/records/8327576


# A mock counts and mock metadata with spatial location generated for a 8 genes by 
# 9 cells object is in /extdata: 

starpath <- system.file(
  file.path("extdata", "STARmapPLUS_small"),
  package = "SpatialExperimentIO")

list.files(starpath)

# One of the following depending on your output (`SPE` or `SCE`) requirement.
star_spe <- readStarmapplusSXE(dirName = starpath)
star_sce <- readStarmapplusSXE(dirName = starpath, returnType = "SCE")


}
\author{
Yixing Estella Dong
}
