% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSeqfishSXE.R
\name{readSeqfishSXE}
\alias{readSeqfishSXE}
\title{Load data from a Spatial Genomics seqFISH experiment}
\usage{
readSeqfishSXE(
  dirName = dirName,
  returnType = "SPE",
  countMatPattern = "CellxGene.csv",
  metaDataPattern = "CellCoordinates.csv",
  coordNames = c("center_x", "center_y")
)
}
\arguments{
\item{dirName}{a directory path to seqFISH download that contains files of interest.}

\item{returnType}{option of \code{"SPE"} or \code{"SCE"}, stands for
\code{SpatialExperiment} or \code{SingleCellExperiment} object. Default value \code{"SPE"}}

\item{countMatPattern}{a filename pattern for the count matrix. Default value is
\code{"CellxGene.csv"}, and there is no need to change.}

\item{metaDataPattern}{a filename pattern for the metadata .csv file that
contains spatial coords. Default value is \code{"CellCoordinates.csv"}, and
there is no need to change.}

\item{coordNames}{a vector of two strings specify the spatial coord names.
Default value is \code{c("center_x", "center_y")}, and there is no need to change.}
}
\value{
a \code{\link{SpatialExperiment}} or a \code{\link{SingleCellExperiment}} object
}
\description{
Creates a \code{\link{SpatialExperiment}} from the downloaded seqFISH
directory for Spatial Genomics seqFISH spatial gene expression data.
}
\details{
The constructor assumes the downloaded seqFISH count matrix and metadata in
the same folder with the following structure:
seqFISH_folder/ \cr
· | — *_CellxGene.csv \cr
· | — *_CellCoordinates.csv \cr
}
\examples{
# A relatively small data download can be from:
# https://spatialgenomics.com/data/#kidney-data


# A mock counts and mock metadata with spatial location generated for a 9 genes by 
# 13 cells object is in /extdata: 

seqfpath <- system.file(
  file.path("extdata", "seqFISH_small"),
  package = "SpatialExperimentIO")
  
list.files(seqfpath)

# One of the following depending on your output (`SPE` or `SCE`) requirement.
seqf_spe <- readSeqfishSXE(dirName = seqfpath)
seqf_sce <- readSeqfishSXE(dirName = seqfpath, returnType = "SCE")


}
\author{
Yixing Estella Dong
}
