% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMerscopeSXE.R
\name{readMerscopeSXE}
\alias{readMerscopeSXE}
\title{Load data from a Vizgen MERSCOPE experiment}
\usage{
readMerscopeSXE(
  dirName = dirName,
  returnType = "SPE",
  countMatPattern = "cell_by_gene.csv",
  metaDataPattern = "cell_metadata.csv",
  coordNames = c("center_x", "center_y")
)
}
\arguments{
\item{dirName}{a directory path to MERSCOPE download that contains files of interest.}

\item{returnType}{option of \code{"SPE"} or \code{"SCE"}, stands for
\code{SpatialExperiment} or \code{SingleCellExperiment} object. Default value \code{"SPE"}}

\item{countMatPattern}{a filename pattern for the count matrix. Default value is
\code{"cell_by_gene.csv"}, and there is no need to change.}

\item{metaDataPattern}{a filename pattern for the metadata .csv file that
contains spatial coords. Default value is \code{"metadata_file.csv"}, and
there is no need to change.}

\item{coordNames}{a vector of two strings specify the spatial coord names.
Default value is \code{c("center_x", "center_y")}, and there is no need to change.}
}
\value{
a \code{\link{SpatialExperiment}} or a \code{\link{SingleCellExperiment}} object
}
\description{
Creates a \code{\link{SpatialExperiment}} from the downloaded MERSCOPE
directory for Vizgen MERSCOPE spatial gene expression data.
}
\details{
The constructor assumes the downloaded MERSCOPE count matrix and metadata in
the same folder with the following structure:
MERSCOPE_folder/ \cr
· | — cell_by_gene.csv \cr
· | — cell_metadata.csv \cr
}
\examples{
# A relatively small data download can be from:
# https://console.cloud.google.com/storage/browser/vz-ffpe-showcase/
# HumanOvarianCancerPatient2Slice2?pageState=(\%22StorageObjectListTable\%22:
# (\%22f\%22:\%22\%255B\%255D\%22))&prefix=&forceOnObjectsSortingFiltering=false


# A mock counts and mock metadata with spatial location generated for a 9 genes by 
# 8 cells object is in /extdata: 

merpath <- system.file(
  file.path("extdata", "MERSCOPE_small"),
  package = "SpatialExperimentIO")
  
list.files(merpath)

# One of the following depending on your output (`SPE` or `SCE`) requirement.
mer_spe <- readMerscopeSXE(dirName = merpath)
mer_sce <- readMerscopeSXE(dirName = merpath, returnType = "SCE")


}
\author{
Yixing Estella Dong
}
