% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addParquetPaths.R
\name{addParquetPathsXenium}
\alias{addParquetPathsXenium}
\title{Add Xenium-related parquet paths to metadata for transcripts or cell/nucleus boundaries.}
\usage{
addParquetPathsXenium(
  sxe,
  dirName,
  addTx = TRUE,
  txMetaNames = "transcripts",
  txPattern = "transcripts.parquet",
  addCellBound = TRUE,
  cellBoundMetaNames = "cell_boundaries",
  cellBoundPattern = "cell_boundaries.parquet",
  addNucBound = TRUE,
  NucBoundMetaNames = "nucleus_boundaries",
  NucBoundPattern = "nucleus_boundaries.parquet"
)
}
\arguments{
\item{sxe}{a SPE or SCE Xenium object to add parquet to \code{metadata(sxe)}.}

\item{dirName}{the directory that stores the transcripts/cell_boundaries/nucleus_boundaries
.parquet files.}

\item{addTx}{to add path to transcripts parquet to \code{metadata(sxe)} or not.
Default is FALSE.}

\item{txMetaNames}{names to add to slots in \code{metadata(sxe)[["name"]]}.
The number of \code{txMetaNames} should equal to number of file detected in \code{dirName}
with \code{txPattern}. Can have multiple, such as \code{c("transcripts", "transcripts1")}.
Default is \code{"transcripts"}.}

\item{txPattern}{.parquet pattern of transcript file in \code{dirName}. Can have multiple,
such as \code{c("transcripts.parquet", "transcripts1.parquet")}. Default value is
\code{"transcripts.parquet"}.}

\item{addCellBound}{to add path to cell boundaries parquet to \code{metadata(sxe)} or not.
Default is FALSE.}

\item{cellBoundMetaNames}{names to add to slots in \code{metadata(sxe)[["name"]]}.
The number of \code{cellBoundMetaNames} should equal to number of file detected in \code{dirName}
with \code{cellBoundPattern}. Can have multiple, such as \code{c("cell_boundaries", "cell_boundaries1")}.
Default is \code{"cell_boundaries"}.}

\item{cellBoundPattern}{.parquet pattern of cell boundaries file in \code{dirName}. Can have multiple,
such as \code{c("cell_boundaries.parquet", "cell_boundaries1.parquet")}. Default value is
\code{"cell_boundaries.parquet"}.}

\item{addNucBound}{to add path to nucleus boundaries parquet to \code{metadata(sxe)} or not.
Default is FALSE.}

\item{NucBoundMetaNames}{names to add to slots in \code{metadata(sxe)[["name"]]}.
The number of \code{NucBoundMetaNames} should equal to number of file detected in \code{dirName}
with \code{NucBoundPattern}. Can have multiple, such as \code{c("nucleus_boundaries", "nucleus_boundaries1")}.
Default is \code{"nucleus_boundaries"}.}

\item{NucBoundPattern}{.parquet pattern of nucleus boundaries file in \code{dirName}. Can have multiple,
such as \code{c("nucleus_boundaries.parquet", "nucleus_boundaries1.parquet")}. Default value is
\code{"nucleus_boundaries.parquet"}.}
}
\value{
a SPE or SCE Xenium object with parquet paths added to metadata
}
\description{
Add Xenium-related parquet paths to metadata for transcripts or cell/nucleus boundaries.
}
\examples{
xepath <- system.file(file.path("extdata", "Xenium_small"),
                      package = "SpatialExperimentIO")

sxe <- readXeniumSXE(dirName = xepath, addParquetPaths = FALSE)
sxe <- addParquetPathsXenium(sxe, dirName = xepath)

}
\author{
Yixing Estella Dong
}
