% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{addParquetPathToMeta}
\alias{addParquetPathToMeta}
\title{Add parquet paths to metadata for transcripts, polygon, or cell/nucleus boundaries.}
\usage{
addParquetPathToMeta(
  sxe,
  dirName = dirName,
  metaNames = "transcripts",
  filePattern = "tx_file.csv"
)
}
\arguments{
\item{sxe}{a SPE or SCE object to add parquet to \code{metadata(sxe)}.}

\item{dirName}{the directory that stores the transcripts/polygon/cell_boundaries
.csv or .parquet files.}

\item{metaNames}{a vector of names to \code{metadata(sxe)[[]]}. The length must
match number of files detected with filePattern provided.
\code{e.g. c("transcripts", "transcripts1.csv")}.}

\item{filePattern}{a vector of file patterns to search in the current directory.
e.g. \code{c("tx_file.csv", "tx_file1.csv")}.}
}
\value{
a SPE or SCE object with parquet paths added to metadata
}
\description{
Add parquet paths to metadata for transcripts, polygon, or cell/nucleus boundaries.
}
\examples{
dir <- system.file(file.path("extdata", "CosMx_small"),
                   package = "SpatialExperimentIO")
sxe <- readCosmxSXE(dir, addParquetPaths = FALSE)
sxe <- addParquetPathToMeta(sxe,
                            dirName = dir,
                            metaNames = "transcripts",
                            filePattern = "tx_file.parquet")

}
